/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

class MachDisplay
extends JFrame {
    private static final long serialVersionUID = 4229342681044359005L;
    JTextArea inArea;
    JLabel[][] mem = new JLabel[17][17];
    JLabel[][] regs = new JLabel[16][2];
    JLabel[][] spRegs = new JLabel[2][2];
    JButton clearb;
    JButton loadb;
    JButton runb;
    JButton stepb;
    JButton haltb;
    JButton helpb;
    boolean running;

    static String toHex(int val, int width) {
        String s = Integer.toHexString(val).toUpperCase();
        while (s.length() < width) {
            s = "0" + s;
        }
        return s;
    }

    static int toInt(String hex) {
        int r = 0;
        try {
            r = Integer.parseInt(hex, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    MachDisplay() {
        super("Simple Computer");
        int j;
        this.setSize(850, 700);
        JPanel contPanel = new JPanel(new BorderLayout());
        JPanel memPanel = new JPanel(new BorderLayout());
        memPanel.add((Component)new JLabel("Main Memory", 0), "North");
        JPanel memContPanel = new JPanel(new GridLayout(17, 17, 5, 5));
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.black, 2));
        memContPanel.setBorder(b);
        memPanel.add((Component)memContPanel, "Center");
        JPanel cpuPanel = new JPanel(new BorderLayout());
        cpuPanel.add((Component)new JLabel("CPU", 0), "North");
        JPanel gpRegPanel = new JPanel(new GridLayout(16, 2, 5, 5));
        JPanel spRegPanel = new JPanel(new GridLayout(2, 2, 5, 5));
        JPanel regPanel = new JPanel(new FlowLayout(0, 15, 0));
        regPanel.setBorder(b);
        regPanel.add((Component)gpRegPanel, "East");
        regPanel.add((Component)spRegPanel, "West");
        cpuPanel.add((Component)regPanel, "Center");
        int i = 0;
        while (i < 16) {
            this.regs[i][0] = new JLabel("R" + MachDisplay.toHex(i, 1));
            this.regs[i][1] = new JLabel("00");
            ++i;
        }
        this.spRegs[0][0] = new JLabel("PC");
        this.spRegs[0][1] = new JLabel("00");
        this.spRegs[1][0] = new JLabel("IR");
        this.spRegs[1][1] = new JLabel("0000");
        i = 0;
        while (i < 17) {
            this.mem[i][0] = new JLabel(MachDisplay.toHex(i - 1, 1), 0);
            j = 1;
            while (j < 17) {
                this.mem[i][j] = i == 0 ? new JLabel(MachDisplay.toHex(j - 1, 1), 0) : new JLabel("00");
                ++j;
            }
            ++i;
        }
        this.mem[0][0].setText("");
        i = 0;
        while (i < 16) {
            gpRegPanel.add(this.regs[i][0]);
            gpRegPanel.add(this.regs[i][1]);
            ++i;
        }
        i = 0;
        while (i < 2) {
            spRegPanel.add(this.spRegs[i][0]);
            spRegPanel.add(this.spRegs[i][1]);
            ++i;
        }
        i = 0;
        while (i < 17) {
            j = 0;
            while (j < 17) {
                memContPanel.add(this.mem[i][j]);
                ++j;
            }
            ++i;
        }
        contPanel.add((Component)cpuPanel, "West");
        contPanel.add((Component)memPanel, "Center");
        JPanel inPanel = new JPanel(new BorderLayout());
        inPanel.add((Component)new JLabel("Data Input Window", 0), "North");
        this.inArea = new JTextArea(10, 10);
        this.inArea.setBorder(b);
        inPanel.add((Component)this.inArea, "Center");
        contPanel.add((Component)inPanel, "North");
        JPanel controls = new JPanel();
        BListen ops = new BListen();
        this.clearb = new JButton("Clear Memory");
        this.clearb.addActionListener(ops);
        controls.add(this.clearb);
        this.loadb = new JButton("Load Data");
        this.loadb.addActionListener(ops);
        controls.add(this.loadb);
        this.runb = new JButton("Run");
        this.runb.addActionListener(ops);
        controls.add(this.runb);
        this.stepb = new JButton("Single Step");
        this.stepb.addActionListener(ops);
        controls.add(this.stepb);
        this.haltb = new JButton("Halt");
        this.haltb.addActionListener(ops);
        controls.add(this.haltb);
        this.helpb = new JButton("Help");
        this.helpb.addActionListener(ops);
        controls.add(this.helpb);
        contPanel.add((Component)controls, "South");
        this.setContentPane(contPanel);
    }

    void clearMem() {
        int i = 1;
        while (i < 17) {
            int j = 1;
            while (j < 17) {
                this.mem[i][j].setText("00");
                ++j;
            }
            ++i;
        }
    }

    void getHelp() {
        String helpString = "The machine is programmed by means of the data input window.\n\nThe syntax follows these examples:\n  [PC] 80            Sets the program counter to 80 (hex).\n  [R7] 23            Sets the contents of register 7 to 23 (hex).\n  [30] 40 56 C0 00   Sets the contents of memory starting\n                     at 30 (hex) to the values 40, 56, C0, 00.\n\nThe syntax is free format. For example, \n         [PC] \n         00 [00] 20 FF\n         40 02 C0 00 \nsets the program counter and memory cells. \n\nOnce changes have been entered into the data input window\n   they can be transferred into the machine by clicking the\n   Load Data button.\n\nPrograms can be placed in the data input window or saved from \n   the data input window by copying (highlight text and then \n   type Ctrl-C) and pasting (Ctrl-V) from or to a text file.\n";
        JDialog helpBox = new JDialog();
        helpBox.setSize(new Dimension(500, 300));
        JTextArea helpArea = new JTextArea(23, 70);
        helpArea.append(helpString);
        JScrollPane helpScrollPane = new JScrollPane(helpArea);
        helpBox.getContentPane().add(helpScrollPane);
        helpBox.setVisible(true);
    }

    void initMem() {
        int i = 0;
        while (i < 16) {
            this.regs[i][1].setText("00");
            ++i;
        }
        this.spRegs[0][1].setText("00");
        this.spRegs[1][1].setText("0000");
        i = 1;
        while (i < 17) {
            int j = 1;
            while (j < 17) {
                this.mem[i][j].setText("00");
                ++j;
            }
            ++i;
        }
        String input = this.inArea.getText();
        int address = 0;
        int rNum = 0;
        int ptr = 0;
        boolean chgReg = false;
        boolean chgMem = false;
        boolean chgPC = false;
        while (ptr < input.length()) {
            char c = input.charAt(ptr);
            if (c <= ' ') {
                ++ptr;
                continue;
            }
            if (c == '[') {
                if ((c = input.charAt(++ptr)) == 'R' || c == 'r') {
                    rNum = MachDisplay.toInt(input.substring(ptr + 1, ptr + 2));
                    chgReg = true;
                    chgMem = false;
                    chgPC = false;
                } else if (c == 'P' || c == 'p') {
                    chgPC = true;
                    chgMem = false;
                    chgReg = false;
                } else {
                    address = MachDisplay.toInt(input.substring(ptr, ptr + 2));
                    chgMem = true;
                    chgPC = false;
                    chgReg = false;
                }
                ptr += 3;
                continue;
            }
            int val = MachDisplay.toInt(input.substring(ptr, ptr + 2));
            ptr += 2;
            if (chgPC) {
                this.spRegs[0][1].setText(MachDisplay.toHex(val, 2));
            }
            if (chgReg) {
                this.regs[rNum][1].setText(MachDisplay.toHex(val, 2));
            }
            if (!chgMem) continue;
            this.mem[address / 16 + 1][address % 16 + 1].setText(MachDisplay.toHex(val, 2));
            ++address;
        }
    }

    void doStep() {
        int loc = MachDisplay.toInt(this.spRegs[0][1].getText());
        if (loc < 0 || loc > 254) {
            System.out.println("Illegal instruction address");
            this.running = false;
            return;
        }
        String byte1 = this.mem[loc / 16 + 1][loc % 16 + 1].getText();
        ++loc;
        String byte2 = this.mem[loc / 16 + 1][(loc &= 0xFF) % 16 + 1].getText();
        ++loc;
        this.spRegs[1][1].setText(String.valueOf(byte1) + byte2);
        this.spRegs[0][1].setText(MachDisplay.toHex(loc &= 0xFF, 2));
        int opcode = MachDisplay.toInt(byte1.substring(0, 1));
        if (opcode == 1) {
            int reg = MachDisplay.toInt(byte1.substring(1, 2));
            int address = MachDisplay.toInt(byte2);
            this.regs[reg][1].setText(this.mem[address / 16 + 1][address % 16 + 1].getText());
        } else if (opcode == 2) {
            int reg = MachDisplay.toInt(byte1.substring(1, 2));
            this.regs[reg][1].setText(byte2);
        } else if (opcode == 3) {
            int reg = MachDisplay.toInt(byte1.substring(1, 2));
            int address = MachDisplay.toInt(byte2);
            this.mem[address / 16 + 1][address % 16 + 1].setText(this.regs[reg][1].getText());
        } else if (opcode == 4) {
            this.regs[MachDisplay.toInt(byte2.substring(1, 2))][1].setText(this.regs[MachDisplay.toInt(byte2.substring(0, 1))][1].getText());
        } else if (opcode == 5) {
            int reg1 = MachDisplay.toInt(byte1.substring(1, 2));
            int reg2 = MachDisplay.toInt(byte2.substring(0, 1));
            int reg3 = MachDisplay.toInt(byte2.substring(1, 2));
            int val2 = MachDisplay.toInt(this.regs[reg2][1].getText());
            int val3 = MachDisplay.toInt(this.regs[reg3][1].getText());
            int sum = val2 + val3 & 0xFF;
            this.regs[reg1][1].setText(MachDisplay.toHex(sum, 2));
        } else if (opcode == 6) {
            int sign3;
            int reg1 = MachDisplay.toInt(byte1.substring(1, 2));
            int reg2 = MachDisplay.toInt(byte2.substring(0, 1));
            int reg3 = MachDisplay.toInt(byte2.substring(1, 2));
            int mant2 = MachDisplay.toInt(this.regs[reg2][1].getText()) % 16;
            int mant3 = MachDisplay.toInt(this.regs[reg3][1].getText()) % 16;
            int exp2 = (MachDisplay.toInt(this.regs[reg2][1].getText()) & 0x70) / 16;
            int exp3 = (MachDisplay.toInt(this.regs[reg3][1].getText()) & 0x70) / 16;
            int[] sign = new int[]{1, -1};
            int sign1 = 0;
            int sign2 = MachDisplay.toInt(this.regs[reg2][1].getText()) / 128;
            int mant1 = (mant2 = (mant2 << exp2) * sign[sign2]) + (mant3 = (mant3 << exp3) * sign[sign3 = MachDisplay.toInt(this.regs[reg3][1].getText()) / 128]);
            if (mant1 < 0) {
                sign1 = 8;
                mant1 = -mant1;
            }
            int exp1 = 0;
            while (mant1 > 15) {
                mant1 /= 2;
                ++exp1;
            }
            this.regs[reg1][1].setText(MachDisplay.toHex((sign1 | exp1) * 16 + mant1, 2));
        } else if (opcode == 7) {
            int reg1 = MachDisplay.toInt(byte1.substring(1, 2));
            int reg2 = MachDisplay.toInt(byte2.substring(0, 1));
            int reg3 = MachDisplay.toInt(byte2.substring(1, 2));
            int val2 = MachDisplay.toInt(this.regs[reg2][1].getText());
            int val3 = MachDisplay.toInt(this.regs[reg3][1].getText());
            int result = val2 | val3;
            this.regs[reg1][1].setText(MachDisplay.toHex(result, 2));
        } else if (opcode == 8) {
            int reg1 = MachDisplay.toInt(byte1.substring(1, 2));
            int reg2 = MachDisplay.toInt(byte2.substring(0, 1));
            int reg3 = MachDisplay.toInt(byte2.substring(1, 2));
            int val2 = MachDisplay.toInt(this.regs[reg2][1].getText());
            int val3 = MachDisplay.toInt(this.regs[reg3][1].getText());
            int result = val2 & val3;
            this.regs[reg1][1].setText(MachDisplay.toHex(result, 2));
        } else if (opcode == 9) {
            int reg1 = MachDisplay.toInt(byte1.substring(1, 2));
            int reg2 = MachDisplay.toInt(byte2.substring(0, 1));
            int reg3 = MachDisplay.toInt(byte2.substring(1, 2));
            int val2 = MachDisplay.toInt(this.regs[reg2][1].getText());
            int val3 = MachDisplay.toInt(this.regs[reg3][1].getText());
            int result = val2 ^ val3;
            this.regs[reg1][1].setText(MachDisplay.toHex(result, 2));
        } else if (opcode == 10) {
            int reg = MachDisplay.toInt(byte1.substring(1, 2));
            int val = MachDisplay.toInt(byte2.substring(1, 2)) % 8;
            int bits = MachDisplay.toInt(this.regs[reg][1].getText());
            int hbits = (0xFF00 & (bits <<= 8 - val)) >> 8;
            int lbits = 0xFF & bits;
            this.regs[reg][1].setText(MachDisplay.toHex(hbits | lbits, 2));
        } else if (opcode == 11) {
            String val2;
            int reg = MachDisplay.toInt(byte1.substring(1, 2));
            String val1 = this.regs[0][1].getText();
            if (val1.equals(val2 = this.regs[reg][1].getText())) {
                this.spRegs[0][1].setText(byte2);
            }
        } else if (opcode == 12) {
            this.running = false;
        } else if (opcode == 13) {
            int reg1 = MachDisplay.toInt(byte1.substring(1, 2));
            int reg2 = MachDisplay.toInt(byte2.substring(1, 2));
            int addr = MachDisplay.toInt(this.regs[reg2][1].getText());
            this.regs[reg1][1].setText(this.mem[addr / 16 + 1][addr % 16 + 1].getText());
        } else if (opcode == 14) {
            int reg1 = MachDisplay.toInt(byte1.substring(1, 2));
            int reg2 = MachDisplay.toInt(byte2.substring(1, 2));
            int addr = MachDisplay.toInt(this.regs[reg2][1].getText());
            this.mem[addr / 16 + 1][addr % 16 + 1].setText(this.regs[reg1][1].getText());
        } else {
            System.out.println("Unexpected opcode=" + opcode);
            this.running = false;
        }
    }

    void doRun() {
        Runner r = new Runner();
        r.start();
    }

    class BListen
    implements ActionListener {
        BListen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object button = e.getSource();
            if (button == MachDisplay.this.clearb) {
                MachDisplay.this.clearMem();
            } else if (button == MachDisplay.this.loadb) {
                MachDisplay.this.initMem();
            } else if (button == MachDisplay.this.runb) {
                MachDisplay.this.doRun();
            } else if (button == MachDisplay.this.stepb) {
                MachDisplay.this.doStep();
            } else if (button == MachDisplay.this.haltb) {
                MachDisplay.this.running = false;
            } else if (button == MachDisplay.this.helpb) {
                MachDisplay.this.getHelp();
            }
        }
    }

    class Runner
    extends Thread {
        Runner() {
        }

        @Override
        public void run() {
            MachDisplay.this.running = true;
            while (MachDisplay.this.running) {
                MachDisplay.this.doStep();
            }
            System.out.println("Simulated execution halted.");
        }
    }
}

