import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class CalendarPanel extends JDialog {
	private JButton[] day;
	private JComboBox month;
	private Calendar calendar;
	private Color lightBlue = new Color(192,255,255);
	private Color lightYellow = new Color(255,255,192);
	private Color lightGreen = new Color(192,255,192);
	private Color green = new Color(128,255,128);
	private TimePanel timePanel = new TimePanel();
	public CalendarPanel(Frame owner) {
		super(owner);
		setModal(true);
		calendar = Calendar.getInstance();
		init();
		setUndecorated(true);
		new EasyMove().install(this);
		setBounds(100,100,400,400);
		setResizable(false);
	}

	public Date getDate() {
		if(calendar!=null) {
			return calendar.getTime();
		}
		else {
			return null;
		}
	}

	private void init() {
		Container c=getContentPane();
		JLabel author = new JLabel("Powered by Yoshi");
		author.setHorizontalAlignment(JLabel.CENTER);
		c.add(author, BorderLayout.SOUTH);
		JPanel dayPanel = new JPanel();
		dayPanel.setLayout(new GridLayout(7,7));
		day = new JButton[42];
		String[] week = new String[]{ "Sun.","Mon.","Tue.","Wed.",
									"Thur.", "Fri.","Sat."};
		for(int i=0; i<7; i++) {
			JLabel label = new JLabel(week[i]);
			label.setOpaque(true);
			label.setBackground(lightGreen);
			label.setHorizontalAlignment(JLabel.CENTER);
			dayPanel.add(label);
		}
		for(int i=0; i<day.length; i++) {
			day[i] = new JButton();
			day[i].setBackground(lightYellow);
			day[i].addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					int s = JOptionPane.showConfirmDialog(CalendarPanel.this, timePanel, "пܮɶ", JOptionPane.OK_CANCEL_OPTION);
					if(s==JOptionPane.OK_OPTION) {
						int x = Integer.parseInt(((JButton)e.getSource()).getText());
						calendar.set(Calendar.DAY_OF_MONTH, x);
						calendar.set(Calendar.HOUR, Integer.parseInt(timePanel.getHour()));
						calendar.set(Calendar.MINUTE, Integer.parseInt(timePanel.getMinute()));
						if(timePanel.getAMPM().equals("AM")) {
							calendar.set(Calendar.AM_PM, Calendar.AM);
						}
						else {
							calendar.set(Calendar.AM_PM, Calendar.PM);
						}
						dispose();
					}
				}
			});
			dayPanel.add(day[i]);
		}
		setDays();
		c.add(dayPanel);

		JPanel upPanel = new JPanel();
		upPanel.setBackground(green);
		c.add(upPanel, BorderLayout.NORTH);

		final JLabel year = new JLabel(""+calendar.get(Calendar.YEAR));
		JButton inc = new JButton("+");
		inc.setBackground(green);
		inc.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String s = year.getText();
				int y = Integer.parseInt(s);
				year.setText(""+(++y));
				calendar.set(Calendar.YEAR, y);
				setDays();
			}
		});
		JButton dec = new JButton("-");
		dec.setBackground(green);
		dec.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String s = year.getText();
				int y = Integer.parseInt(s);
				year.setText(""+(--y));
				calendar.set(Calendar.YEAR, y);
				setDays();
			}
		});
		JButton cancel = new JButton("Cancel");
		cancel.setBackground(green);
		cancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dispose();
				calendar = null;
			}
		});
		upPanel.add(new JLabel("K"));
		upPanel.add(year);
		upPanel.add(inc);
		upPanel.add(dec);

		String[] s = new String[]{"January", "February", "March", "April",
			"May", "June", "July", "August", "September", "October",
			"November", "December"};
		month = new JComboBox(s);
		month.setBackground(green);
		month.setSelectedIndex(calendar.get(Calendar.MONTH));
		month.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				int i=month.getSelectedIndex();
				switch(i) {
					case 0: i = Calendar.JANUARY; break;
					case 1: i = Calendar.FEBRUARY; break;
					case 2: i = Calendar.MARCH; break;
					case 3: i = Calendar.APRIL; break;
					case 4: i = Calendar.MAY; break;
					case 5: i = Calendar.JUNE; break;
					case 6: i = Calendar.JULY; break;
					case 7: i = Calendar.AUGUST; break;
					case 8: i = Calendar.SEPTEMBER; break;
					case 9: i = Calendar.OCTOBER; break;
					case 10: i = Calendar.NOVEMBER; break;
					case 11: i = Calendar.DECEMBER; break;
				}
				calendar.set(Calendar.MONTH, i);
				setDays();
			}
		});
		upPanel.add(month);
		upPanel.add(cancel);
	}
	private void setDays() {
		Calendar tmp = (Calendar) calendar.clone();
		tmp.set(Calendar.DAY_OF_MONTH, 1);
		int offset=0;
		switch(tmp.get(Calendar.DAY_OF_WEEK)) {
			case Calendar.SUNDAY: offset = 0; break;
			case Calendar.MONDAY: offset = 1; break;
			case Calendar.TUESDAY: offset = 2; break;
			case Calendar.WEDNESDAY: offset = 3; break;
			case Calendar.THURSDAY: offset = 4; break;
			case Calendar.FRIDAY: offset = 5; break;
			case Calendar.SATURDAY: offset = 6; break;
		}
		for(int i=0; i<day.length; i++) {
			day[i].setBackground(lightYellow);
		}
		for(int i=0; i<offset; i++) {
			day[i].setText("");
			day[i].setEnabled(false);
		}
		int lastDay = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
		for(int i=offset; i<lastDay+offset; i++) {
			day[i].setText(i-offset+1+"");
			day[i].setEnabled(true);
		}
		for(int i=lastDay+offset; i<day.length; i++) {
			day[i].setText("");
			day[i].setEnabled(false);
		}
		Calendar today = Calendar.getInstance();
		if(today.get(Calendar.YEAR) == calendar.get(Calendar.YEAR)
		 && today.get(Calendar.DATE) == calendar.get(Calendar.DATE)
		 && today.get(Calendar.MONTH) == calendar.get(Calendar.MONTH)) {
			day[offset+calendar.get(Calendar.DAY_OF_MONTH)-1].setBackground(lightBlue);
		}
	}

	public static void main(String[] args) {
		CalendarPanel calPanel = new CalendarPanel(null);
		calPanel.setVisible(true);
		Date d = calPanel.getDate();
		System.out.println(d);
	}
	
}

