import java.awt.Color;
import java.awt.Graphics;
import java.text.DecimalFormat;

import javax.swing.JPanel;

class DrawPanel extends JPanel {
	private double[] x,y;
	private DecimalFormat df = new DecimalFormat("##0.00");
	private int width, height;
	private double maxY;
	public DrawPanel(int width, int height) {
		this.width = width;
		this.height = height;

	}
	public void setXY(double[] x, double[] y) {
		this.x = x;
		this.y = y;
		//System.out.println("(" + x[i] +"," + y[i]+")");
	}
	public void setMaxY(double y) {
		maxY = y;
	}
	public void paintComponent(Graphics g) {
		int t = (int) ((-1)*y[0]+height/2);
		int pastT = t;
		g.setColor(Color.BLUE);
		for(int i=1; i<width; i++) {
			t = (int) ((-1)*y[i]+height/2);
			g.drawLine(i-1, pastT, i, t);
			pastT = t;
		}
		g.setColor(Color.BLACK);
		//I
		g.drawString("0", width/2-15, height/2+15);
		//x, yb
		g.drawLine(0,height/2, width, height/2);
		g.drawLine(width/2, 0, width/2, height);
		//xb
		for(int i=1; i<8; i++) {
			g.drawLine(i*width/8, height/2-5, i*width/8, height/2+5);
		}
		//ҭ
		drawValue(g, width/4, height/2, x[width/4]);
		drawValue(g, width*3/4, height/2, x[width*3/4]);
		//yb
		for(int i=1; i<8; i++) {
			g.drawLine(width/2-5, i*height/8, width/2+5, i*height/8);
		}
		//ҭ
		drawValue(g, width/2, height/4, maxY/2d);
		drawValue(g, width/2, height*3/4, maxY*(-1)/2d);
	}
	//ХXX, YbW
	public void drawValue(Graphics g, int x, int y, double value) {
		String s = df.format(value);
		if(y == height/2) {
			g.drawString(s, x-3*s.length(), y+20);
		}
		else {
			g.drawString(s, x-8*s.length(), y+5);
		}
	}
	
}
