import java.awt.*;

import javax.swing.*;
import java.text.*;

public class Mathenobita extends JFrame {
	//user define
	public static final double RANGE = 30; //XbkiZ
	public static final int WIDTH = 1024;
	public static final int HEIGHT = 600;
	private double function(double x) {
		return Math.tan(x);
	}
	//

	private DrawPanel panel;
	private double[] x,y;
	private int width, height;
	public Mathenobita(int width, int height) {
		this.width = width;
		this.height = height;
		x = new double[width];
		y = new double[width];
		panel = new DrawPanel(width, height);
		calculate();
		setTitle("Mathenobita");
		setBounds(50,50, width, height+30);
		setResizable(false);
		Container c = getContentPane();
		setBackground(Color.WHITE);
		c.add(panel);
		show();
	}

	private void calculate() {
		double max = Double.MIN_VALUE;
		double pivot = 0;
		double inc = RANGE/width;
		for(int i=width/2; i<width; i++) {
			x[i] = pivot;
			y[i] = function(x[i]);
			if(Math.abs(y[i]) > max) {
				max = Math.abs(y[i]);
			}
			pivot+=inc;
		}
		inc*=-1;
		pivot=inc;
		for(int i=width/2-1; i>=0; i--) {
			x[i] = pivot;
			y[i] = function(x[i]);
			if(Math.abs(y[i]) > max) {
				max = Math.abs(y[i]);
			}
			pivot+=inc;
		}
		//f(x)ӤjAyϫu
		if( max > 3*RANGE) {
			max = RANGE;
		}
		//jYp , MҤlYi
		double mapping = height/(2*max);
		for(int i=0; i<width; i++) {
			y[i]=y[i]*mapping;
		}
		panel.setMaxY(max);
		panel.setXY(x,y);

	}

	public static void main(String[] args) {
		Mathenobita obj = new Mathenobita(Mathenobita.WIDTH,Mathenobita.HEIGHT);
		obj.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
}
