package cs340100.net.httpserver.threaded;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;

public class ProcessingUnit extends Thread {
	Socket client;

	public ProcessingUnit(Socket client) {
		this.client = client;
	}

	@Override
	public void run() {
		try {
			processClient(client);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.out.println("Connection close.");
		}
	}

	private void processClient(Socket client) throws IOException {
		InputStream in = client.getInputStream();
		OutputStream out = client.getOutputStream();
		BufferedReader bIn = new BufferedReader(new InputStreamReader(in));
		BufferedOutputStream bOut = new BufferedOutputStream(out);
		bOut.write("HTTP/1.1 200 OK\nServer: YoshiServer\n\n".getBytes());
		String line = "";
		while ((line = bIn.readLine()) != null) {
			// System.out.println(line);
			String[] cmd = line.split(" ");
			if (cmd[0].equalsIgnoreCase("GET")) {
				System.out.println(line); // we skip all other lines except
											// those starting with "GET"
				try {
					FileInputStream toSendFile = new FileInputStream("WWW/"
							+ cmd[1].substring(1));
					BufferedInputStream fileToSend = new BufferedInputStream(
							toSendFile);
					int data = 0;
					while ((data = fileToSend.read()) != -1) {
						bOut.write(data);
					}
					bOut.flush();
				} catch (FileNotFoundException e) {
					FileInputStream toSendFile = new FileInputStream(
							"WWW/sponge.jpg");
					BufferedInputStream fileToSend = new BufferedInputStream(
							toSendFile);
					int data = 0;
					while ((data = fileToSend.read()) != -1) {
						bOut.write(data);
					}
					bOut.flush();
					break;
				}
			}
			break;
		}
		client.close();
	}

}
