#include "stdio.h"
#include "conio.h"
#include "math.h"
#include "svgacc.h"

#define step 128
#define no_of_cities 99

int city[2][no_of_cities];
long map[no_of_cities][no_of_cities];

void load_city_map() {
  char line[80];
  FILE * f = fopen("rat99.tsp", "rt");
  int t1, t2, t3;
  for(int i = 0; i < 99; i++) {
    fgets(line, 80, f);
    sscanf(line, "%d %d %d", &t1, &t2, &t3);
    city[0][i] = t2 * 1.2;
    city[1][i] = t3 * 1.2;
  }
}

void main(int argc, char * argv[]) {
  whichvga();
  res640();
  load_city_map();

  int c, ic, oldc;
  char line[80];
  char * d[5] = {"1st(1288)","2nd(1337)","3rd(1365)","4th(1320)","5th(1330)"};

for(int i=0; i < 5; i++) {
  drwstring(SET, 10+i, 0, d[i], step*i, 280);
  for(int j = 0; j < no_of_cities; j++)
    drwcircle(SET, 15, city[0][j] + step * i, city[1][j], 4);

  FILE * f = fopen(argv[i + 1], "rt");
  fgets(line, 80, f);
  sscanf(line, "%d", &c);
  ic = c;
  oldc = c;
  long distance = 0;
  while (!feof(f)) {
    fgets(line, 80, f);
    sscanf(line, "%d", &c);
    drwline(SET, 10+i, city[0][oldc] + step * i, city[1][oldc], city[0][c] + step * i, city[1][c]);
    oldc = c;
  }
  fclose(f);
}
  pcxmake(0, 0, 639, 319, "sa1-6.pcx");
  while(!kbhit()); getch();
  restext();
}