clear;   
Ts=0.1       %sampling time
data_n=130    %the number of training datas

A=[ -7    16     -18
     1     0       0
     0     1       0 ]
B=[0 0 1]'
C=[1 0 0]
D=0                                      
pole=eig(A)      
controlbi=[B A*B A^2*B]
rankn=rank(controlbi)
pause

[Ad,Bd,Cd,Dd]=c2dm(A,B,C,D,Ts,'zoh')


%% choose a desired model and get training data
%wn=60;
%da=3;
%F=[  0      1       
%    -wn^2  -da*wn];
%G=[0;wn^2];
%H=[1 0]
F=[ -29  -200  -400
    1      0     0
    0      1     0];
G=[0 0 1]';
H=[1 0 0];
D=0;               
DesireP=eig(F)
pause
[Fd,Gd,Hd,Id]=c2dm(F,G,H,D,Ts,'zoh')                  

%%% create training data
des_gap(1)=0;des_dgap(1)=0;des_i(1)=0;
sys_gap(1)=0.1;sys_dgap(1)=0;sys_i(1)=0;
ind=[1:1:data_n-1];                                                            

for j=ind,
 stad_r(j)=1;
 des_gap(j+1) =Fd(1,1)*des_gap(j)+Fd(1,2)*des_dgap(j)+Fd(1,3)*des_i(j)+Gd(1,1)*stad_r(j);
 sys_gap(j+1) =Ad(1,1)*sys_gap(j)+Ad(1,2)*sys_dgap(j)+Ad(1,3)*sys_i(j)+Bd(1,1)*stad_r(j);              

 des_dgap(j+1)=Fd(2,1)*des_gap(j)+Fd(2,2)*des_dgap(j)+Fd(2,3)*des_i(j)+Gd(2,1)*stad_r(j);
 sys_dgap(j+1)=Ad(2,1)*sys_gap(j)+Ad(2,2)*sys_dgap(j)+Ad(2,3)*sys_i(j)+Bd(2,1)*stad_r(j);                            
 
 des_i(j+1)   =Fd(3,1)*des_gap(j)+Fd(3,2)*des_dgap(j)+Fd(3,3)*des_i(j)+Gd(3,1)*stad_r(j);
 sys_i(j+1)   =Ad(3,1)*sys_gap(j)+Ad(3,2)*sys_dgap(j)+Ad(3,3)*sys_i(j)+Bd(3,1)*stad_r(j);             
end;      

Xk(1)=0;
j=ind;                                                                
Xk(j+1)=(des_gap(j+1)-(Ad(1,1)*sys_gap(j)+Ad(1,2)*sys_dgap(j)+Ad(1,3)*sys_i(j)))/Bd(1,1);

u=ones(data_n,1);
u(1,1)=0;
trn_data=[u Xk' des_gap'];

%%% Train ANFIS
NumMfs = 2;
MfType = 'gbellmf';
NumEpochs = 20;
ErrorGoal = 0.05;
StepSize = 1;
InputFismat = genfis1(trn_data, NumMfs, MfType);
OutputFismat = anfis(trn_data, InputFismat, [NumEpochs ErrorGoal StepSize]);

%%% Control
%% initialize  
new_gap(1)=0.1;new_dgap(1)=0; new_i(1)=0;
ref_gap(1)=1;ref_dgap(1)=0; ref_i(1)=0;
k=1;
U=1;

%% start to simulate 
while abs(new_gap(k)- ref_gap(k))>0.02 & new_gap(k)<1e3,

k
input=[U,new_gap(k)]
plantI(k) = evalfis(input , OutputFismat);
                                            
new_gap(k+1) =Ad(1,1)*new_gap(k)+Ad(1,2)*new_dgap(k)+Ad(1,3)*new_i(k)+Bd(1,1)*plantI(k);
new_dgap(k+1)=Ad(2,1)*new_gap(k)+Ad(2,2)*new_dgap(k)+Ad(2,3)*new_i(k)+Bd(2,1)*plantI(k);
new_i(k+1)   =Ad(3,1)*new_gap(k)+Ad(3,2)*new_dgap(k)+Ad(3,3)*new_i(k)+Bd(3,1)*plantI(k);
ref_gap(k+1) =Fd(1,1)*ref_gap(k)+Fd(1,2)*ref_dgap(k)+Fd(1,3)*ref_i(k)+Gd(1,1)*U;
ref_dgap(k+1)=Fd(2,1)*ref_gap(k)+Fd(2,2)*ref_dgap(k)+Fd(2,3)*ref_i(k)+Gd(2,1)*U;
ref_i(k+1)   =Fd(3,1)*ref_gap(k)+Fd(3,2)*ref_dgap(k)+Fd(3,3)*ref_i(k)+Gd(3,1)*U;
InputFismat = OutputFismat;
l=length(trn_data);
ref_Xk(k)=(ref_gap(k+1)-(Ad(1,1)*new_gap(k)+Ad(1,2)*new_dgap(k)+Ad(1,3)*new_i(k)))/Bd(1,1);
trn_data=[trn_data(2:l,:)
          U new_gap(k) ref_Xk(k)];
[OutputFismat,error] = anfis(trn_data, InputFismat, [NumEpochs ErrorGoal StepSize]);
k=k+1;

end;


%%% plot step response before control
figure 
step(A,B,C,D)
title('Step response of unstable system(order 3)')
%%% plot the process
T=[0:Ts:Ts*(k-1)];
figure;                           
plot(T,new_gap,'r-',T,ref_gap,'g--');  
title('Specialized learning(order 3, TD_n=130)');
xlabel('Time');  ylabel('position');   

figure
plot(error);
title('Root mean squared error(order 3, TD_n=130)');
                    

