program TitForTat;

#include "str.h"

type
	ParseType = (trade, cheat, null);

var
	score: array[1..10] of Integer;
	plan: array[1..10] of string;
	lasti1, lasti2, lastj1, lastj2: ParseType;
	i, j, n, k: Integer;


procedure Inc (var num: Integer; amount: Integer);

	begin
	num := num + amount;
	end;


procedure Init;

	var
		count, posn: Integer;
		hold, line: string;

	begin
	n := 0;
	repeat
		readln(line);
		if (line <> '#') then
			begin
			while (length(line) <> 0) and (line[length(line)] <> '.') do
				begin
				readln(hold);
				line := line + hold;
				end;
			Delete(line, Length(line), 1);
			Inc(n, 1);
			score[n] := 0;
			plan[n] := '';
			while (Pos(' ', line) <> 0) do
				Delete(line, Pos(' ', line), 1);
			while (line <> '') do
				begin
				case line[1] of
				'I': 
					begin
					plan[n] := plan[n] + 'I';
					Delete(line, 1, 2);
					end;
				'T': 
					if (line[2] = 'H') then
						begin
						plan[n] := plan[n] + 'T';
						Delete(line, 1, 4);
						end
					else
						begin
						plan[n] := plan[n] + '+';
						Delete(line, 1, 5);
						end;
				'E': 
					begin
					plan[n] := plan[n] + 'E';
					Delete(line, 1, 4);
					end;
				'A': 
					begin
					plan[n] := plan[n] + '&';
					Delete(line, 1, 3);
					end;
				'O': 
					begin
					plan[n] := plan[n] + '|';
					Delete(line, 1, 2);
					end;
				'N': 
					begin
					plan[n] := plan[n] + 'N';
					Delete(line, 1, 4);
					end;
				'C': 
					begin
					plan[n] := plan[n] + '-';
					Delete(line, 1, 5);
					end;
				'=': 
					begin
					plan[n] := plan[n] + '=';
					Delete(line, 1, 1);
					end;
				'#': 
					begin
					plan[n] := plan[n] + '#';
					Delete(line, 1, 1);
					end;
				'M': 
					begin
					plan[n] := plan[n] + line[7];
					Delete(line, 1, 7);
					end;
				'Y': 
					begin
					plan[n] := plan[n] + Chr(Ord(line[9]) + 2);
					Delete(line, 1, 9);
					end;
				end;
				end;
			end;
	until (line = '#');
	end;



function Parse (line: string;
								my1, my2, your1, your2: ParseType): ParseType;

	var
		thenPos, count, elsePos: Integer;


	function Eval (cond: string): Boolean;

		var
			temp: string;
			ch: Char;
			len, res: Integer;
			first, second: ParseType;

		begin
		temp := '';
		while (cond <> '') do
			begin
			case cond[1] of
			'1': 
				first := my1;
			'2': 
				first := my2;
			'3': 
				first := your1;
			'4': 
				first := your2;
			end;
			case cond[3] of
			'+': 
				second := trade;
			'-': 
				second := cheat;
			'N': 
				second := null;
			end;
			case cond[2] of
			'=': 
				temp := temp + Chr(Ord(first = second));
			'#': 
				temp := temp + Chr(Ord(first <> second));
			end;

			Delete(cond, 1, 3);

			if (cond <> '') then
				begin
				temp := temp + cond[1];
				Delete(cond, 1, 1);
				end;
			end;

		while (Length(temp) > 1) do
			begin
			len := Length(temp);
			if (temp[len - 1] = '&') then
				res := Ord(temp[len - 2]) * Ord(temp[len])
			else
				res := Ord(temp[len - 2]) + Ord(temp[len]);

			if (res = 0) then
				ch := Chr(0)
			else
				ch := Chr(1);
			temp := Copy(temp, 1, len - 3) + ch;
			end;

		Eval := (temp[1] <> Chr(0));
		end;


	begin
	if (line[1] = '+') then
		Parse := trade
	else if (line[1] = '-') then
		parse := cheat
	else
		begin
		thenPos := Pos('T', line);
		count := 1;
		elsePos := 2;
		while (count > 0) do
			begin
			if (line[elsePos] = 'I') then
				count := count + 1
			else if (line[elsePos] = 'E') then
				count := count - 1;
			elsePos := elsePos + 1;
			end;
		elsePos := elsePos - 1;

		if Eval(Copy(line, 2, thenPos - 2)) then
			Parse := Parse(Copy(line, thenPos + 1, elsePos - (thenPos + 1)), my1, my2, your1, your2)
		else
			Parse := Parse(Copy(line, elsePos + 1, 255), my1, my2, your1, your2);
		end;
	end;



procedure Play (i, j: Integer);

	var
		movei, movej: ParseType;

	begin
	movei := Parse(plan[i], lasti1, lasti2, lastj1, lastj2);
	movej := Parse(plan[j], lastj1, lastj2, lasti1, lasti2);
	if (movei = trade) and (movej = trade) then
		begin
		score[i] := score[i] + 1;
		score[j] := score[j] + 1;
		end
	else if (movei = trade) and (movej = cheat) then
		begin
		score[i] := score[i] + -2;
		score[j] := score[j] + 2;
		end
	else if (movei = cheat) and (movej = trade) then
		begin
		score[i] := score[i] + 2;
		score[j] := score[j] - 2;
		end
	else
		begin
		score[i] := score[i] - 1;
		score[j] := score[j] - 1;
		end;
	lasti2 := lasti1;
	lasti1 := movei;
	lastj2 := lastj1;
	lastj1 := movej;
	end;


begin
Init;
for i := 1 to n - 1 do
	for j := i + 1 to n do
		begin
		lasti1 := null;
		lasti2 := null;
		lastj1 := null;
		lastj2 := null;
		for k := 1 to 10 do
			Play(i, j);
		end;
for i := 1 to n do
	writeln(score[i] : 3);
end.